#include <Wire.h>
#include <display_init.h>
#include <PIR_Sensor_Init.h>
#include <Speaker_Init.h>
#include <Temp_IR_Init.h>
int count=0;
#include <TimedAction.h>
bool log_stat = false;
//************************************SD Card Setup***********************************
void sdcard_setup()
{
//  Serial.begin(9600);
  if(!SD.begin(SD_ChipSelectPin))
  {
    Serial.println("SD Card Init failed");
    return;
  }
  Serial.println("SD CaArd Init Done.");
  File dataFile = SD.open("datalog.txt",   FILE_WRITE);
  // if the file is available, write to it:
  if (dataFile) {
    dataFile.close();
    Serial.println("Log File Detected!");
    // print to the serial port too:
  } 
}

//************************************Display Section********************************

void showmsgXY(int x, int y, int sz, const GFXfont *f, String msg, const char *color)
{
    int16_t x1, y1;
    uint16_t wid, ht;
    tft.setFont(f);
    tft.setCursor(x, y);
    tft.setTextColor(color);
    tft.setTextSize(sz);
    tft.print(msg);
    Serial.println(msg);
//    delay(1000);
}


void log_screen()
{
    showmsgXY(70, 20, 1, &FreeSans9pt7b, msg[0],WHITE); //Project Name
    showmsgXY(190, 40, 1, &FreeSans9pt7b, msg[1],WHITE);// Team Name
    tft.drawFastHLine(0, 44, tft.width(), WHITE); // Line
    left_btn.initButton(&tft,  160, 280,  60,40, BLACK, CYAN, WHITE, "<", 1);
    right_btn.initButton(&tft, 240,  280, 60,40, BLACK, CYAN, WHITE, ">", 1);
    exit_btn.initButton(&tft,  320, 280,  60,40, BLACK, CYAN, WHITE, "EXIT", 1);
    left_btn.drawButton(false);
    right_btn.drawButton(false);
    exit_btn.drawButton(false);
    Serial.println("Log Screen Displayed");

}

void home_screen()
{
    tft.fillScreen(WHITE);
    showmsgXY(70, 20, 1, &FreeSans9pt7b, msg[0],BLACK); //Project Name
    showmsgXY(190, 40, 1, &FreeSans9pt7b, msg[1],BLACK);// Team Name
    tft.drawFastHLine(0, 44, tft.width(), BLACK); // Line
    showmsgXY(10, 80, 1, &FreeSans9pt7b, msg[2],BLACK); // Ambient temp
    showmsgXY(10, 120, 1, &FreeSans9pt7b, msg[3],BLACK); // Target temp
    showmsgXY(10, 160, 1, &FreeSans9pt7b, msg[4],BLACK); // Result
    showmsgXY(10, 200, 1, &FreeSans9pt7b, "COUNT                               :",BLACK); // Person Count
    left_btn.initButton(&tft,  80, 280,  60,40, BLACK, CYAN, BLACK, "<", 1);
    right_btn.initButton(&tft, 160, 280, 60,40, BLACK, CYAN, BLACK, ">", 1);
    exit_btn.initButton(&tft,  320, 280,  60,40, BLACK, CYAN, BLACK, "EXIT", 1);
    log_btn.initButton(&tft,   240, 280,  60,40, BLACK, CYAN, BLACK, "LOGS", 1);
    log_btn.drawButton(false);
    left_btn.drawButton(false);
    right_btn.drawButton(false);
    exit_btn.drawButton(false);
    Serial.println("Home Screen Displayed");

}

void clear_value()
{
   tft.drawRect(250, 60, 150, 120, WHITE);
   tft.fillRect(250, 60, 150, 120, WHITE);
   Serial.println("Past Values Cleared");

}
bool Touch_getXY(void)
{
    TSPoint p = ts.getPoint();
    pinMode(YP, OUTPUT);      //restore shared pins
    pinMode(XM, OUTPUT);
    digitalWrite(YP, HIGH);   //because TFT control pins
    digitalWrite(XM, HIGH);
    bool pressed = (p.z > MINPRESSURE && p.z < MAXPRESSURE);
    if (pressed) {
        pixel_x = map(p.y, TS_BOT, TS_TOP, 0, tft.width());
        pixel_y = map(p.x, TS_LEFT, TS_RT, 0, tft.height());
    }
    Serial.println("Pixel X Value");
    Serial.println(pixel_x);
    Serial.println("Button XY touch coordinates received");
    Serial.println("Pixel Y Value");
    Serial.println(pixel_y);
    return pressed;
}

void log_button_scan()
{
    bool down = Touch_getXY();
    log_btn.press(down && log_btn.contains(pixel_x, pixel_y));
    if (log_btn.justPressed()){
        retrievelog();
        Serial.println("Log Button Pressed");
        log_btn.drawButton(false);
        }
     exit_btn.press(down && exit_btn.contains(pixel_x, pixel_y));
      if (exit_btn.justPressed()){
        home_screen();
        Serial.println("Exit Button Pressed");
        log_stat = false;
        exit_btn.drawButton(false);
        }
}
TimedAction timedAction  = TimedAction(100,log_button_scan);

void touch_display_setup()
{
//   Serial.begin(9600);
    tft.reset();
    uint16_t ID = tft.readID();
    ID = 0x9486; // write-only shield
    tft.begin(ID);
    tft.setRotation(aspect);
   Serial.println("Touch Display Init Done!");
    home_screen(); 
}


//************************************Speaker Section********************************
void speaker_setup()
{
  tmrpcm.speakerPin=46;
  tmrpcm.setVolume(5);
  Serial.println("Speaker Init Done!");
}

//************************************Data Logging Section****************************
void datalog(String dataString)
{
 Serial.println("Data Log Started");
 File dataFile = SD.open("datalog.txt", FILE_WRITE);
 if (dataFile) {
     Serial.println("Data Log Done!");
     dataFile.println(dataString);
     dataFile.close();
  }
  // if the file isn't open, pop up an error:
  else {
    Serial.println("Error opening datalog.txt");
  }
}  
void retrievelog()
{
  Serial.println("Data Retrieve Started");
  int i = 0;
  tft.drawRect(10, 60, 400, 180, WHITE);
  tft.fillRect(10, 60, 400, 180, WHITE);
  File dataFile = SD.open("datalog.txt");
  if (dataFile) { 
      while (dataFile.available()) { //execute while file is available
      String line = dataFile.readStringUntil('\n');
      i = i+20;
      showmsgXY(10, 80+i, 1, &FreeSans9pt7b, line, BLACK); //Project Name
      Serial.println(line);
      if(i == 140)
      {
        Serial.println("break");
        Serial.println("Data Retrieve Successful");
        log_stat = true;
        break;
      }
      }      
//      String letter = dataFile.read(); //read next character from file
    dataFile.close(); //close file
//    delay(10000);
  }
}

//************************************Temprature Sensor Section****************************
void thermal_ir_sensor_setup()
{
 mlx.begin();//initalize temp sensor
 Serial.println("Thermal IR Init Sucessful");

}

void temp_scan()
{ 
  Serial.println("Temperature Scan Started");
  count = count + 1;
  tft.drawRect(250, 180, 40, 30, WHITE);
  tft.fillRect(250, 180, 40, 30, WHITE); 
  showmsgXY(250, 200, 1, &FreeSans9pt7b, String(count),BLACK); // Pass   
  String log_value;
  ambient = mlx.readAmbientTempC(); 
  target = mlx.readObjectTempC(); 
  target = target + 12.5;
  target = ((target * 1.8) + 32);
  ambient = ((ambient * 1.8) + 32);
  dtostrf(ambient, 6, 2, amb); // Converting float to char
  dtostrf(target, 6, 2, tar); //  Converting float to char
  showmsgXY(250, 80, 1, &FreeSans9pt7b, amb,BLACK); // Ambient value
  showmsgXY(320, 80, 1, &FreeSans9pt7b, msg[7],BLACK); // Unit Celcius for ambient value
  showmsgXY(250, 120, 1, &FreeSans9pt7b, tar,BLACK); // Target value
  showmsgXY(320, 120, 1, &FreeSans9pt7b, msg[7],BLACK);// Unit Celcius for target value
  Serial.println("Ambient Temp in deg C!"); 
  Serial.println(ambient); 
  Serial.println("Target Temp in deg C!"); 
  Serial.println(target); 
  if (target > threshold){
    showmsgXY(250, 160, 1, &FreeSans9pt7b, msg[6],RED); // Fail
    tmrpcm.play("Audio_4.wav");
    Serial.println("Playing Announcement 4");
    Serial.println("Target temperature is higher than 38degC - Failed");
    String result = msg[6];
    delay(7000);
  }
  else{
  showmsgXY(250, 160, 1, &FreeSans9pt7b, msg[5],GREEN); // Pass  
      Serial.println("Playing Announcement 3");
 
    tmrpcm.play("Audio_3.wav");
    Serial.println("Target temperature is less than 38degC - Passed");
    String result = msg[5];
    delay(7000);
  }
  log_value = String("Time in mS:") + String(millis()) + String(" Count=") + String(count) + String(" Target_Temp=")+ String(target) + String("C ") + result;
  Serial.println("Data Logged");
  Serial.println(log_value);
  datalog(log_value);
  delay(10000);
  clear_value();
}

//************************************Motion Sensor Section****************************

void motion_sensor_setup()
{
  pinMode(pir_led, OUTPUT);   // initalize LED as an output
  pinMode(pir_input, INPUT);    // initialize sensor as an input
  Serial.println("Motion Sensor Init Done!");

}

void motion_scan()
{
    Serial.println("Motion Scan Started");
    if (digitalRead(pir_input) == HIGH) { // check if the sensor is HIGH
    digitalWrite(pir_led, HIGH);      // turn LED ON 
    Serial.println("Motion detected!"); 
    Serial.println("Playing Announcement 1");
    tmrpcm.play("Audio_1.wav");
    delay(2000);
    Serial.println("Playing Announcement 2");
    tmrpcm.play("Audio_2.wav");
    delay(7000);
    temp_scan();
  } 
  else {
    digitalWrite(pir_led, LOW);       // turn LED OFF
    Serial.println("No Motion Detected");
//    delay(1000);                   // delay 100 milliseconds
  }
}


//************************************Main Setup Section****************************

void setup()
{
  Serial.begin(9600);     // initialize serial
  Serial.println("Started All Modules Init");
  sdcard_setup();
  speaker_setup();
  motion_sensor_setup(); // initialize PIR motion sensor
  thermal_ir_sensor_setup();// initialize thermal IR motion sensor
  touch_display_setup();// initialize touch display
  home_screen(); //Shows the home screen with history button to view past records (person count, time stamp, temperature)
}

//************************************Main Polling Loop Section****************************

void loop()
{
//  Serial.println("Motion Scan In Progress"); 
//   timedAction.check();
     log_button_scan();
  if (log_stat==false)
  {
     motion_scan(); // Check PIR sensor and takes decision based on its output
   }
//  Serial.println("Button Scan In Progress"); 
//  log_button_scan();
  //delay(15000);
}
